//=============================================================================
// AllWeapons (Fully Loaded). Edited by TheDane to give full loaded weapons
//=============================================================================
class AWFL expands Mutator config(AllWeaponsFullyLoaded);

var config bool bGiveRedeemer;

function ModifyPlayer(Pawn Other)
{
	//this was lifted from the Loaded function in the DeathMatchPlus class
	GiveWeapon(Other, "Botpack.PulseGun");
	GiveWeapon(Other, "Botpack.ShockRifle");
	GiveWeapon(Other, "Botpack.UT_FlakCannon");
	GiveWeapon(Other, "Botpack.UT_BioRifle");
	GiveWeapon(Other, "Botpack.Minigun2");
	GiveWeapon(Other, "Botpack.SniperRifle");
	GiveWeapon(Other, "Botpack.Ripper");
	GiveWeapon(Other, "Botpack.UT_Eightball");
	
	if ( bGiveRedeemer )
		GiveWeapon(Other, "Botpack.WarheadLauncher");

	if ( NextMutator != None )
		NextMutator.ModifyPlayer(Other);
}

//this was lifted from the DeathMatchPlus class
function GiveWeapon(Pawn PlayerPawn, string aClassName )
{
	local class<Weapon> WeaponClass;
	local Weapon NewWeapon;

	WeaponClass = class<Weapon>(DynamicLoadObject(aClassName, class'Class'));

	if( PlayerPawn.FindInventoryType(WeaponClass) != None )
		return;
	newWeapon = Spawn(WeaponClass);
	if( newWeapon != None )
	{
		newWeapon.RespawnTime = 0.0;
		newWeapon.GiveTo(PlayerPawn);
		newWeapon.bHeldItem = true;
		newWeapon.GiveAmmo(PlayerPawn);
		newWeapon.SetSwitchPriority(PlayerPawn);
		newWeapon.WeaponSet(PlayerPawn);
		newWeapon.AmbientGlow = 0;
		if ( PlayerPawn.IsA('PlayerPawn') )
			newWeapon.SetHand(PlayerPawn(PlayerPawn).Handedness);
		else
			newWeapon.GotoState('Idle');
		PlayerPawn.Weapon.GotoState('DownWeapon');
		PlayerPawn.PendingWeapon = None;
		PlayerPawn.Weapon = newWeapon;
		newWeapon.AmmoType.AmmoAmount = newWeapon.AmmoType.MaxAmmo;
	}
}

